<?php
/**
 * Static Block widget
 * @package automatic
 */

class WP_Automatic_Widget_StaticBlock extends WP_Widget {

    public function __construct() {
        $widget_ops = array( 'classname' => 'automatic_widget_staticblock', 'description' => esc_html__( "Display Static Block Slide", "automatic") );
        parent::__construct( 'automatic-static-block', esc_html__( '[Automatic] Static Block', 'automatic' ), $widget_ops );
        $this->alt_option_name = 'automatic_widget_static_block';
    }
    public function widget( $args,  $instance ) {
        echo $args['before_widget'];
        ?>
        <?php
             if ( $instance['title'] ) {
                echo '<h2 class="widget-title-category">'.esc_html($instance['title']) . '</h2>';
            }
        ?>
        <div class="automatic-widget automatic-static-block">
            <?php
            if ( $instance['id_post'] != '' ) :
                $argas = array(
                    'post_type' => 'block',
                    'post_status' => 'publish',
                    'p' => $instance['id_post'],
                );
                $rquery = New Wp_Query( $argas );
                if ( $rquery -> have_posts() ) :
                    while ( $rquery -> have_posts() ) : $rquery -> the_post();
                        $shortcodes_custom_css = get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
                        if ( ! empty( $shortcodes_custom_css ) ) {
                            $shortcodes_custom_css = strip_tags( $shortcodes_custom_css );
                            echo '<style type="text/css" data-type="vc_shortcodes-custom-css">';
                            echo ($shortcodes_custom_css);
                            echo '</style>';
                       }
                       the_content();
                    endwhile;
                    wp_reset_postdata();
                endif;
            endif;
            ?>
        </div>
        <?php
        echo $args['after_widget'];
    }
     /*Update data widget*/
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = $new_instance['title'];
        $instance['id_post'] = $new_instance['id_post'];
        return $instance;
    }

    /*Layout admin widget*/
    public function form( $instance ) {
        $id_post = isset( $instance['id_post'] ) ? wp_kses($instance['id_post'],array('span'=>array('class'=>array()))) : '';
        $title   = isset( $instance['title'] ) ? esc_html($instance['title']) : esc_html__('','automatic');
        ?>
        <p><label for="<?php echo  esc_html($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','automatic' ); ?></label>
        <input class="widefat" id="<?php echo  esc_html($this->get_field_id( 'title' )); ?>" name="<?php echo  esc_html($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo  esc_html($title); ?>" /></p>
        <?php
        $argas = array(
            'post_type' => 'block',
            'post_status' => 'publish',
            'posts_per_page' => -1,
        );
        $rquery = New Wp_Query( $argas );
        if ( $rquery -> have_posts() ) :
            ?>
            <p><label for="<?php echo  esc_html($this->get_field_id( 'id_post' )); ?>"><?php esc_html_e( 'Static Block:','automatic' ); ?></label>
            <select name="<?php echo  esc_html($this->get_field_name( 'id_post' )); ?>">
                <option value=""><?php echo esc_html__('Select Item','automatic');?></option>
                <?php
                while ( $rquery -> have_posts() ) : $rquery -> the_post();
                    ?>
                    <option value="<?php the_ID();?>" <?php selected( $id_post, get_the_ID() );?>><?php the_title();?></option>
                    <?php
                endwhile;
                ?>
            </select>
            <?php
            wp_reset_postdata();
        endif;

        ?>
    <?php
    }

}
